<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Canceled Booking Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 20px;
        }
        .report-container {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            max-width: 100%;
        }
        h1 {
            font-size: 20px;
            margin-bottom: 10px;
        }
        .report-header {
            background-color: yellow;
            text-align: center;
            font-weight: bold;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
            text-align: center;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
        }
        thead {
            background: #f0f0f0;
        }
        .highlight-green {
            background-color: #c7f6c7;
        }
        .highlight-red {
            background-color: #f8caca;
        }
    </style>
</head>
<body>
    <div class="report-container">
        <h1>Canceled Bookings Details</h1>
      
        <table>
            <thead>
                <tr>
                    <th>UNIT#</th>
                    <th>UNIT TYPE</th>
                    <th>BUILDING / PROJECT</th>
                    <th>CANCEL TYPE</th>
                    <th>CUSTOMER</th>
                    <th>AGENT INFO</th>
                    <th>BOOKING DATE</th>
                    <th>CANCEL DATE</th>
                    <th>PRICE</th>
                    <th>RECEIPTS</th>
                    <th>REFUND</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $model; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($item->unitname); ?></td>
                        <td><?php echo e($item->buildingname); ?></td>
                        <td><?php echo e($item->unittype); ?></td>
                        <td><?php echo e($item->cancel_type == 1  ? 'Cancel'  : ($item->cancel_type == 2  ? 'Suspended' : ($item->cancel_type == 3 ? 'Merger' : '-'))); ?></td>
                        <td><?php echo e($item->customername); ?></td>
                        <td><?php echo e($item->agentinfo); ?></td>
                        <td><?php echo e($item->booking_date); ?></td>
                        <td><?php echo e($item->cancel_date); ?></td>
                        <td><?php echo e($item->net_price); ?></td>
                        <td><?php echo e($item->total_receipts); ?></td>
                        <td><?php echo e($item->total_refunds); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>

           
        </table>
    </div>
</body>
</html>
<?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/cancel_booking.blade.php ENDPATH**/ ?>