

<?php $__env->startSection('content'); ?>
    <div class="document">
        <div class="document-heading">
            <div class="container">
                <div class="row">
                    <div class="col col-12" style="text-align: center">
                        <img src="<?php echo e(asset('storage/app/uploads/' . settings()->get('uploaded_logo'))); ?>"
                            height="170" />
                    </div>
                </div>

                <br>
                <div class="row">
                    <div class="col col-4">
                        <div class="row">
                            <div class="col col-12">
                                <p class="color-black text-capitalize rcorners2" style="font-size: 19px; font-weight:bold;">
                                    <u>Receipt</u>
                                </p>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col col-12">
                                <p class="color-black text-capitalize rcorners2" style="font-size: 17px">
                                    <?php echo e(settings()->get('company_name')); ?></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col col-12">
                                <p class="color-black text-capitalize rcorners2" style="font-size: 17px">
                                    <?php echo e(settings()->get('company_address')); ?></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col col-12">
                                <p class="color-black text-capitalize rcorners2" style="font-size: 17px">Contact No.
                                    <?php echo e(settings()->get('company_telephone')); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php if($model->bounce_date): ?>
                        <div class="col col-4">
                            <p style="font-size: 16px; font-weight:bold; color:#dd4430"><span
                                    style="font-size: 24px; font-weight:bold; color:#dd4430">Cheque Bounced </span>
                                <?php echo e(date('d-M-Y', strtotime($model->bounce_date))); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="col col-4">
                            <p style="font-size: 24px; font-weight:bold; color:#f35641">&nbsp;</p>
                        </div>
                    <?php endif; ?>
                    <div class="col col-4">
                        <table class="table" width="100%"
                            style="text-align: center; font-size: 15px; border:1px solid #eee">
                            <thead>
                                <tr>
                                    <th style="text-align:center">DATE</th>
                                    <th class="align-center" style=" text-transform: uppercase;">
                                        <?php echo e($model ? \Carbon\Carbon::parse($model->payment_date)->format('d-M-Y') : '-'); ?>

                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="border: 1px solid #eee;">
                                    <td class="align-center">RECEIPT NO.</td>
                                    <td class="align-center"><?php echo e($model ? $model->number : '-'); ?></td>
                                </tr>
                                <tr style="border: 1px solid #eee;">
                                    <td class="align-center">OLD RECEIPT NO.</td>
                                    <td class="align-center"><?php echo e($model ? $model->ref_no : ''); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>






                <div class="document-body">
                    <table class="document-table" width="100%" style="font-size: 15px">
                        <tbody>
                            <?php $__currentLoopData = $model->unitsale->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td width="15%" style="font-size: 15px; font-weight:bold">Buyer Name:</td>
                                    <td width="85%" style="font-size: 15px; font-weight:normal">
                                        <?php echo e($item->client ? $item->client->person : '-'); ?></td>
                                </tr>
                                <tr>
                                    <td width="15%" style="font-size: 15px; font-weight:bold">Address:</td>
                                    <td width="15%" style="font-size: 15px; font-weight:normal">
                                        <?php echo e($item->client ? ($item->client->billing_address ? $item->client->billing_address : '-') : '-'); ?>

                                    </td>
                                </tr>
                                <tr class="table-tr">
                                    <td width="15%" style="font-size: 15px; font-weight:bold">Email:</td>
                                    <td width="15%" style="font-size: 15px; font-weight:normal">
                                        <?php echo e($item->client ? $item->client->email : '-'); ?></td>
                                </tr>
                                <tr class="table-tr">
                                    <td width="15%" style="font-size: 15px; font-weight:bold">Contact #</td>
                                    <td width="15%" style="font-size: 15px; font-weight:normal">
                                        <?php echo e($item->client ? $item->client->mobile_number : '-'); ?></td>
                                </tr>
                                <?php if($index != count($model->unitsale->items) - 1): ?>
                                    <tr height="1%">
                                        <td colspan="2"></td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>



                <div class="document-body">
                    <table class="document-table" width="100%" style="font-size: 15px">
                        <thead>
                            <tr class="table-th">
                                <th width="25%" style="text-align: center; background-color: #604700; color:white;">
                                    PROJECT DETAILS</th>
                                <th width="25%"
                                    style="text-align: center; background-color: white; color:#3f3f3e;text-transform: uppercase;font-weight: bold;">
                                    <?php echo e($model->unitsale->unit->building->project->projectname); ?></th>
                                <th width="25%" style="text-align: center; background-color: #604700; color:white;">UNIT
                                    #</th>
                                <th width="25%"
                                    style="text-align: center; background-color: white; color:#3f3f3e;text-transform: uppercase;font-weight: bold; ">
                                    <?php echo e($model && $model->unitsale->unit ? $model->unitsale->unit->unitname : '-'); ?></th>

                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="row">
                    <div class="col col-12">
                        <div class="document-body">
                            <table class="document-table" width="100%" style="font-size: 15px">
                                <thead>

                                    <tr class="table-th">
                                        <th width="15%"
                                            style="text-align: center; background-color: #604700; color:white; text-transform: uppercase;  ">
                                            Date</th>
                                        <th width="15%"
                                            style="text-align: center; background-color: #604700; color:white; text-transform: uppercase;  ">
                                            Mode</th>
                                        <th width="35%"
                                            style="text-align: center; background-color: #604700; color:white; text-transform: uppercase;  ">
                                            Particulars</th>
                                        
                                        <th width="15%"
                                            style="text-align: center; background-color: #604700; color:white; text-transform: uppercase;  ">
                                            Amount</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                        $totalReceived = 0;
                                        $itemCount = count($model->item);
                                    ?>
                                    <?php if(count($model->item) > 0): ?>
                                        <?php $__currentLoopData = $model->item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $totalReceived += $item->amount_received;
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <tr class="table-tr">
                                            <td class="align-center">
                                                <?php echo e($model ? \Carbon\Carbon::parse($model->payment_date)->format('d-M-Y') : '-'); ?>

                                            </td>
                                            <td class="align-center">
                                                <?php echo e($model && $model->paymentmode ? $model->paymentmode->paymentmodedetail : '-'); ?>

                                            </td>
                                            <td class="align-center">Amount
                                                Received From Customer Against Unit No
                                                <?php echo e($model && $model->unitsale->unit ? $model->unitsale->unit->unitname : '-'); ?>

                                            </td>
                                            
                                            <td class="align-right">  <img width="13px" height="13px" src="images/darm-black.svg" alt="SVG Image"> <?php echo e(number_format($totalReceived, 2)); ?></td>
                                        </tr>
                                    <?php else: ?>
                                        <tr class="table-tr">
                                            <td class="align-center">
                                                <?php echo e($model ? \Carbon\Carbon::parse($model->payment_date)->format('d-M-Y') : '-'); ?>

                                            </td>
                                            <td class="align-center">
                                                <?php echo e($model && $model->paymentmode ? $model->paymentmode->paymentmodedetail : '-'); ?>

                                            </td>
                                            <td class="align-center">
                                                <?php echo e($model ? ($model->client ? $model->client->person ?? '-' : '-') : '-'); ?>

                                            </td>
                                            <td class="align-center"></td>
                                            
                                        </tr>
                                    <?php endif; ?>
                                    <tr class="table-tr">
                                        <td class="align-center"></td>
                                        <td class="align-center"></td>
                                        <td class="align-center">&nbsp;</td>
                                        <td class="align-center"></td>
                                        
                                    </tr>
                                    <tr>
                                        <td colspan="4" class="align-right">Total
                                            Received&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                            <img width="13px" height="13px" src="images/darm-black.svg" alt="SVG Image"> <?php echo e(number_format($totalReceived, 2)); ?></td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col col-12">
                        <p class="color-black text-capitalize rcorners2 px-2 py-2"
                            style="font-size: 18px; font-weight:bold">Terms and Conditions:</p>
                    </div>
                    <div class="col col-12">
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* Booking Deposit is
                            Non-Refundable.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* Terms & Condition as
                            per Sales & Purchase agreement Apply.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* Payment must be paid
                            on stipulated due month as per agreed payment Plan.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* Payment mode can be
                            cheque or Online transfer.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* If amount is paid by
                            Cheque then this receipt is valid only on realization of cheques , If cheques are dishonoured
                            and unpaid by bank &nbsp;&nbsp;&nbsp;then this receipt is null and void.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* In case of cheque
                            bounced / returned / unpaid then cheque return penalty of <img width="13px" height="13px" src="images/darm-black.svg" alt="SVG Image"> <b>500</b> will be applied along
                            with delay penalties.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* If the receipt is
                            issued against Proforma Receipt then proforma Receipt will be null and void.</p>
                        <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* If SPA is not signed,
                            and deal is cancelled by buyer then all the paid amounts are non refundable and will be
                            forfeited by developer as &nbsp;&nbsp;reasonable administrations , finance charges.</p>
                        <?php if($model->paymentmode->id == 8): ?>
                            <p class="color-black text-capitalize rcorners2" style="font-size: 14px;">* This receipt is
                                subject to the clearance of funds from the bank, approval, and successful processing. Any
                                reversals, chargebacks, or dishonored payments will render this receipt null and void.</p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col col-12">
                        <p class="color-black text-capitalize" style="font-size: 14px;">This is System Generated does not
                            require any signature or stamp for verification Please Contact accounts@empiredevelopment.ae
                        </p>
                    </div>
                </div>
                <hr>
                
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<style>
    table {
        border-collapse: collapse;
    }

    th {
        background: #ccc;
    }

    th,
    td {
        border: 1px solid #ccc;
        font-weight: bold;
        padding: 8px;
        font-family: 'Trebuchet MS', sans-serif
    }

    /* tr:nth-child(even) {
  background: #efefef;
} */

    tr:hover {
        background: #d1d1d1;
    }

    .top-heading {
        font-size: 32px;
        font-weight: bold;
    }

    .table-tr th {
        text-align: center;
    }
</style>

<?php echo $__env->make('docs.master', ['title' => $data['title']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/paymentReciept.blade.php ENDPATH**/ ?>