<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Monthly Collection Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 20px;
        }

        .report-container {
            max-width: 100%;
        }

        h1 {
            font-size: 20px;
            margin-bottom: 10px;
        }

        .report-header {
            background-color: yellow;
            text-align: center;
            font-weight: bold;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 14px;
            text-align: center;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ddd;
        }

        thead {
            background: #f0f0f0;
        }

        .highlight-green {
            background-color: #c7f6c7;
        }

        .highlight-red {
            background-color: #f8caca;
        }
    </style>
</head>

<body>
    <div class="report-container">
       <?php
            use Carbon\Carbon;

            $now = Carbon::now();

            $reportDate = $now->copy();

            if ($now->day < 26) {
                $reportDate->subMonthNoOverflow();
            }

            $reportDate->day = 26;

            $formattedReportDate = $reportDate->format('26 F Y');
            ?>

            <div class="report-header">
                MONTHLY COLLECTION REPORT AS ON <?php echo e($formattedReportDate); ?>

            </div>

        <table>
            <thead>
                <tr>
                    <th>PROJECT</th>
                    <th>TOTAL ACCOUNTS</th>
                    <th>CURRENT DUE</th>
                    <th>JULY INSTALLMENT DUE</th>
                    <th>TOTAL MONTH OVERDUE</th>
                    <th>TOTAL COLLECTED</th>
                    <th>COLLECTION RATE</th>
                    <th>Bounce Cheque</th>
                    <th>PENDING TO COLLECT</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $totalUnits = 0;
                    $totalDue = 0;
                    $currentMonthDue = 0;
                    $totalDueWithCurrent = 0;
                    $totalReceived = 0;
                    $bounceCheque = 0;
                    $pendingUnits = 0;
                    $totalReceivedPercentage = 0;
                ?>

                <?php $__currentLoopData = $model; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($item->project)): ?>
                        <tr class="highlight-green">
                            <td><?php echo e($item->project); ?></td>
                            <td><?php echo e($item->total_units); ?></td>
                            <td><?php echo e(number_format($item->collection_monthly_installment_last_month_25_due, 2)); ?></td>
                            <td><?php echo e(number_format($item->collection_monthly_installment_current_month_due, 2)); ?></td>
                            <td><?php echo e(number_format($item->collection_monthly_installment_last_month_25_due + $item->collection_monthly_installment_current_month_due, 2)); ?>

                            </td>
                            <td><?php echo e(number_format($item->collection_monthly_installment_current_month_received, 2)); ?></td>
                            <td><?php echo e(number_format(
                                ($item->collection_monthly_installment_current_month_received / ($item->collection_monthly_installment_last_month_25_due + $item->collection_monthly_installment_current_month_due)) * 100,
                                2,
                            )); ?>%
                            </td>
                            <td><?php echo e(number_format($item->bounce_cheque, 2)); ?></td>
                            <td><?php echo e($item->pending_units); ?></td>
                        </tr>
                        <?php
                            $totalUnits += $item->total_units;
                            $totalDue += $item->collection_monthly_installment_last_month_25_due;
                            $currentMonthDue += $item->collection_monthly_installment_current_month_due;
                            $totalDueWithCurrent += $item->collection_monthly_installment_last_month_25_due + $item->collection_monthly_installment_current_month_due;
                            $totalReceived += $item->collection_monthly_installment_current_month_received;
                            $totalReceivedPercentage +=
                                ($item->collection_monthly_installment_current_month_received /
                                    ($item->collection_monthly_installment_last_month_25_due + $item->collection_monthly_installment_current_month_due)) *
                                100;
                                $bounceCheque += $item->bounce_cheque;
                            $pendingUnits += $item->pending_units;
                        ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <tr>
                    <td><b>TOTAL</b></td>
                    <td><?php echo e($totalUnits); ?></td>
                    <td><?php echo e(number_format($totalDue, 2)); ?></td>
                    <td><?php echo e(number_format($currentMonthDue, 2)); ?></td>
                    <td class="highlight-red"><?php echo e(number_format($totalDueWithCurrent, 2)); ?></td>
                    <td><?php echo e(number_format($totalReceived, 2)); ?></td>
                    <td class="highlight-red">
                        <?php
                            $avgRate = $model->count() > 0 ? $totalReceivedPercentage / $model->count() : 0;
                        ?>
                        <?php echo e(number_format($avgRate, 2)); ?>%
                    </td>
                    <td><?php echo e(number_format($bounceCheque, 2)); ?></td>
                    <td><?php echo e($pendingUnits); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</body>

</html>
<?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/monthly_collection_report.blade.php ENDPATH**/ ?>