<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">

    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="manifest" href="site.webmanifest">
    <link rel="shortcut icon" href="<?php echo e(url('images/favicon.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(url('images/favicon.png')); ?>" type="image/x-icon">
    <meta name="description" content="particles.js is a lightweight JavaScript library for creating particles.">
    <meta name="author" content="Vincent Garreau" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <!-- Place favicon.ico in the root directory -->
    <title><?php echo e(settings()->get('app_title')); ?></title>


    <link rel="stylesheet" href="/css/normalize.css">
    <link rel="stylesheet" href="/css/bootstrap.min.css">
    <link rel="stylesheet" href="/css/font-awesome.min.css">
    <link rel="stylesheet" href="/css/hover-min.css">
    <link rel="stylesheet" href="/css/stylelogin.css">
    <link rel="stylesheet" href="/css/responsive.css">
    <meta name="theme-color" content="#fafafa">
    <style>
        .container {
            width: 100% !important;
            max-width: 400px;
            margin: 0 auto;
            padding: 20px;
        }

        .particles-js-canvas-el {
            z-index: -10;
        }

        .form-group {
            margin-bottom: 1.5rem;
            position: relative;
        }

        .input-wrapper {
            position: relative;
            width: 100%;
        }

        .form-control {
            width: 100%;
            padding: 12px 12px 12px 40px;
            height: 50px;
            /* Increased height from default ~38px to 50px */
            border: 1px solid #ced4da;
            font-size: 16px;
            transition: border-color 0.3s ease;
        }

        .form-control:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.3);
            outline: none;
        }

        .input-icon {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            width: 33px;
            height: 33px;
            object-fit: contain;
        }

        .error-message {
            display: block;
            margin-top: 5px;
            font-size: 14px;
            color: #dc3545;
        }

        .btn-dark {
            width: 100%;
            padding: 12px;
            font-size: 16px;
            font-weight: 500;
            text-transform: capitalize;
            border: none;
            border-radius: 36px;
            /* Added rounded corners */

            transition: 0.3s ease;
            background: -webkit-linear-gradient(45deg, rgba(255, 227, 141, 1) 16%, rgba(186, 136, 89, 1) 72%) !important;
            background: linear-gradient(45deg, rgba(255, 227, 141, 1) 16%, rgba(186, 136, 89, 1) 72%) !important;
        }

        /* Method 1: Using Flexbox */
        .container {
            min-height: 100vh;
        }

        .login-form {
            width: 100%;
        }

        /* OR Method 2: Using Grid */
        .container {
            min-height: 100vh;
        }

        .img-responsive {
            width: 250px !important;
            margin-bottom: 130px !important;
        }
    </style>
</head>

<body>
    <!-- particles.js container -->
    <div id="particles-js">
        <div class="container mt-5">
            <a href="/">
                <img src="<?php echo e(url('images/logo.png')); ?>" class="img-responsive mx-auto d-block site-logo mb-5"
                    alt="Empire Developments Logo" title="Empire Developments Logo" />
            </a>

            <div class="">
                <h1 class="text-center poppins-semi-bold color-primary mt-5 mb-4 login">Login</h1>
                <form action="/login" method="POST" class="login-form">
                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">

                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="form-control"
                                placeholder="Enter your email" id="email" required aria-label="Email">
                            <img src="<?php echo e(url('images/user-img.png')); ?>" class="input-icon" alt="User icon">
                        </div>
                        <?php if($errors->has('email')): ?>
                            <small class="error-message text-danger">
                                <?php echo e($errors->first('email')); ?>

                            </small>
                        <?php endif; ?>
                    </div>

                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="password" name="password" class="form-control"
                                placeholder="Enter your password" id="password" required aria-label="Password">
                            <img src="<?php echo e(url('images/pass.png')); ?>" class="input-icon password-icon"
                                alt="Password icon">
                        </div>
                        <?php if($errors->has('password')): ?>
                            <small class="error-message text-danger">
                                <?php echo e($errors->first('password')); ?>

                            </small>
                        <?php endif; ?>
                    </div>

                    <button type="submit" class="btn btn-dark btn-block">
                        Login Now
                    </button>
                </form>
            </div>
        </div>
    </div>



    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
    <script>
        window.jQuery || document.write('<script src="js/vendor/jquery-3.3.1.min.js"><\/script>')
    </script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.min.js"></script>
    <script src="js/particles.js"></script>
    <!-- scripts -->
    <script src="js/applogin.js"></script>
    <!-- stats.js -->
    <script>
        var count_particles, stats, update;
        stats = new Stats;
        stats.setMode(0);
        stats.domElement.style.position = 'absolute';
        stats.domElement.style.left = '0px';
        stats.domElement.style.top = '0px';
        document.body.appendChild(stats.domElement);
        count_particles = document.querySelector('.js-count-particles');
        update = function() {
            stats.begin();
            stats.end();
            if (window.pJSDom[0].pJS.particles && window.pJSDom[0].pJS.particles.array) {
                count_particles.innerText = window.pJSDom[0].pJS.particles.array.length;
            }
            requestAnimationFrame(update);
        };
        requestAnimationFrame(update);
    </script>
</body>

</html>
<?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/login.blade.php ENDPATH**/ ?>