<!DOCTYPE html>
<html>

<head>
    <style>
        @page {
            margin: 0px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body>
    <div style="border: 3px solid #000; padding: 30px; margin: 20px 24px 0px 10px; background: #fff; min-height: 120vh;">
        <!-- Header Section with Logo and Title -->
        <table style="width: 100%; margin-bottom: 10px; border-collapse: collapse;" cellpadding="0" cellspacing="0">
            <tr>
                <td style="text-align: center; padding: 40px 0;">
                    <img src="<?php echo e(base_path('images/logo-black.png')); ?>" width="400" alt="Logo"
                        style="max-width: 100%; height: auto;">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; padding: 40px 0;">
                    <table style="width: 100%; border-collapse: collapse;" cellpadding="0" cellspacing="0">
                        <tr>
                            <!-- Left Border -->
                            <td style="border-bottom: 3px solid #f4e4bc; width: 30%; vertical-align: middle;">&nbsp;
                            </td>

                            <!-- Center Gradient Box -->
                            <td
                                style="text-align: center; vertical-align: middle; font-weight: bold; font-size: 32px; letter-spacing: 3px;
                                                   background: linear-gradient(to right, #f9e9b6, #f4e4bc, #e6d097);
                                                   color: #355e3b;
                                                   padding: 15px 40px;
                                                   border-radius: 30px;
                                                   text-transform: uppercase;
                                                   white-space: nowrap;
                                                   line-height: 1.4;">
                                EXPRESSION OF INTEREST
                            </td>

                            <!-- Right Border -->
                            <td style="border-bottom: 3px solid #f4e4bc; width: 30%; vertical-align: middle;">&nbsp;
                            </td>
                        </tr>
                    </table>

                </td>
            </tr>
        </table>

        <!-- Date Section -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr style="background-color: rgb(6, 50, 4)">
                <td width="25%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;">Date :</p>
                </td>
                <td width="50%" colspan="2" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;"><?php echo e(\Carbon\Carbon::now()->format('d-M-Y')); ?>

                    </p>
                </td>
                <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;">: التاریخ</p>
                </td>
            </tr>
        </table>

        <!-- Seller Details -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr>
                <td colspan="2" width="50%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 22px; margin: 0;">1. SELLER'S DETAILS</p>
                </td>
                <td colspan="2" width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">تفاصیل البائع</p>
                </td>
            </tr>
            <tr>
                <td colspan="2" width="50%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 18px; margin: 0;">
                        <span style="font-weight: bold;">M/S <?php echo settings()->get('company_name'); ?></span> a DED License No.
                        <span style="font-weight: bold;">1271154 Address</span> –, Dubai, United Arab Emirates,
                        Successors – In –Title Or Permitted Assigns
                    </p>
                </td>
                <td colspan="2" width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 18px; margin: 0;">
                        م /ث إمبایر للتطویر العقاري رخصة دائرة التنمیة الاقتصادیة رقم 1271154العنوان -دبي ،
                        الإمارات العربیة المتحدة ، الخلفاء - في -العنوان أو المتنازل لھم المسموح بھم
                    </p>
                </td>
            </tr>
        </table>

        <!-- Purchaser Details -->
        <?php if($model->clients && $model->clients[0]->client !== null): ?>
            <?php $__currentLoopData = $model->clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            
                <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 30px;">
                    <?php if($loop->first): ?>
                        <tr style="background-color: rgb(6, 50, 4);">
                            <td width="25%" style="padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">Applicant Details :</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">Purchaser</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">: المشترى المشترك</p>
                            </td>
                            <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">التفاصیل المقدمة</p>
                            </td>
                        </tr>
                    <?php elseif($loop->iteration == count($model->clients) - 1): ?>
                        <tr>
                            <td width="25%" style="padding: 10px; border: 1px solid black;">
                                <p style="font-weight: bold; font-size: 20px; margin: 0;">Applicant Details :</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-weight: bold; font-size: 20px; margin: 0;">Joint Purchaser</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-weight: bold; font-size: 20px; margin: 0;">: المشتري</p>
                            </td>
                            <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                                <p style="font-weight: bold; font-size: 20px; margin: 0;">التفاصیل المقدمة</p>
                            </td>
                        </tr>
                    <?php elseif($loop->last): ?>
                        <tr style="background-color: rgb(6, 50, 4);">
                            <td width="25%" style="padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">Applicant Details :</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">Joint Purchaser</p>
                            </td>
                            <td width="25%" style="text-align: center; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">: المشتري</p>
                            </td>
                            <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                                <p style="font-size: 20px; color: white; margin: 0;">التفاصیل المقدمة</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 20px; margin: 0;">PURCHASER Name :</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 20px; margin: 0;">
                                <?php echo e($client->client->person ? $client->client->person : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 20px; margin: 0;">
                                <?php echo e($client->client->person1 ? $client->client->person1 : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 20px; margin: 0;">: اسم المشترى</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Address</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->billing_address ? $client->client->billing_address : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->address ? $client->client->address : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">العنوان</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">P.O. Box</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">رقم صندوق البرید ص ب</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Emirate</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">أمارة</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Phone/Mobile</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->mobile_number ? $client->client->mobile_number : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->mobile_number ? $client->client->mobile_number : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">رقم الھاتف / المحمول</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Email</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->email ? $client->client->email : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->email ? $client->client->email : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">البريد الإلكتروني</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Country</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->country ? $client->client->country['countryname'] : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->country ? $client->client->country['other_language'] : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">الدولة</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Nationality</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->national ? $client->client->national['countryname'] : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->national ? $client->client->national['other_language'] : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">جنسية</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Passport No. / Exp. Date</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->passport_no ? $client->client->passport_no : '-'); ?> /
                                <?php echo e($client->client->passport_expire ? date('d-M-Y', strtotime($client->client->passport_expire)) : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">
                                <?php echo e($client->client->passport_expire ? date('d-M-Y', strtotime($client->client->passport_expire)) : '-'); ?>

                                / <?php echo e($client->client->passport_no ? $client->client->passport_no : '-'); ?>

                            </p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">رقم جواز السفر . تاریخ الأنتھاء</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">EID / Trade License No.</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">رقم الھویة / رقم الرخصة التجاریة</p>
                        </td>
                    </tr>
                    <tr>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">Visa No. / Visa Exp. Date</p>
                        </td>
                        <td width="25%" style="padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">-</p>
                        </td>
                        <td width="25%" style="text-align: right; padding: 10px; border: 1px solid black;">
                            <p style="font-size: 18px; margin: 0;">رقم الآقامة / تاریخ الأنتھاء</p>
                        </td>
                    </tr>
                </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <!-- Purchase Details -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr style="background-color: rgb(6, 50, 4);">
                <td width="50%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 22px; color: white; margin: 0;">3. PURCHASE DETAILS:</p>
                </td>
                <td width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;">تفاصیل الشراء</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">Building :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">
                        <span
                            style="font-weight: bold;"><?php echo e($model->project ? $model->project->projectname : '-'); ?></span><br>
                        <span><?php echo e($model->project ? $model->project->plot_no : ''); ?></span><br />
                        <?php echo e($model->project ? $model->project->area : '-'); ?>

                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">: المبنى</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Floor :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">
                        <?php echo e($model->floorname ? $model->floorname : '-'); ?>

                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: الطابق</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Unit No.</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">
                        <?php echo e($model->unitname ? $model->unitname : '-'); ?>

                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">رقم الوحدة</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">No. of Parking</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">
                        <?php echo e($model->parking ? $model->parking : '-'); ?>

                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">عدد مواقف السیارات</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Total Area (Sq. ft) :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-weight: bold; font-size: 20px; margin: 0;">
                        <?php echo e($model->gross_area ? $model->gross_area : '-'); ?>

                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">المساحة الأجمالیة قدم .مربع</p>
                </td>
            </tr>
        </table>

        <!-- Purchase Price Section -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr style="background-color: rgb(6, 50, 4);">
                <td width="50%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 22px; color: white; margin: 0;">4. Indicative Purchase Price:</p>
                </td>
                <td width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;">سعر الشراء الإرشادي</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Amount in AED :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">
                        <span
                            style="font-weight: bold;"><?php echo e($model->net_price ? number_format($model->net_price, 2) : '0'); ?></span>
                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: الأجمالى</p>
                </td>
            </tr>
        </table>

        <!-- EOI Deposit Details -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr style="background-color: rgb(6, 50, 4);">
                <td width="50%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 22px; color: white; margin: 0;">5. EOI Deposit DETAILS: (AED)</p>
                </td>
                <td width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; color: white; margin: 0;">تفاصيل إيداع التعبير عن الاهتمام: (درهم
                        إماراتي)</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Cheque No :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">
                        <span style="font-weight: bold;"><?php echo e($model->cheque_nos ? $model->cheque_nos : ''); ?></span>
                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: شیك رقم</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Cheque Date :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: تاریخ الشیك</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Amount :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">
                        <span
                            style="font-weight: bold;"><?php echo e($model->amount_received ? $model->amount_received : ''); ?></span>
                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: المبلغ</p>
                </td>
            </tr>
            <tr>
                <td width="35%" style="padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">Bank/Cash :</p>
                </td>
                <td width="30%" style="text-align: center; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">
                        <span style="font-weight: bold;"><?php echo e($model->branches ? $model->branches : ''); ?></span>
                    </p>
                </td>
                <td width="35%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p style="font-size: 20px; margin: 0;">: بنك</p>
                </td>
            </tr>
        </table>

        <table
            style="width: 100%; margin-top: 70px; border-top: 2px solid black; padding-top: 20px; border-collapse: collapse;"
            cellpadding="0" cellspacing="0">
            <tr>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Seller</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Purchaser</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Joint Purchaser</p>
                </td>
            </tr>
        </table>
        

        <!-- Permitted Use -->
       <div class="page-break" style="padding-top:40px">
    <table style="border: 1px solid black; border-collapse: collapse; width: 100%;">
        <tr style="background-color: rgb(6, 50, 4);">
            <td width="35%" style="border: 1px solid black; padding: 20px 10px;">
                <p style="font-size: 20px; color: white; margin: 0;">7. Permitted Use:</p>
            </td>
            <td width="30%" style="text-align: center; border: 1px solid black; padding: 20px 10px;">
                <p style="font-size: 20px; color: white; margin: 0;"><?php echo e($model->classname); ?></p>
            </td>
            <td width="35%" style="text-align: right; border: 1px solid black; padding: 20px 10px;">
                <p style="font-size: 20px; color: white; margin: 0;">الاستخدام المسموح بھ :</p>
            </td>
        </tr>
    </table>


    <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr>
                <td width="50%" style="padding: 10px; border: 1px solid black;">
                    <p
                        style="font-size: 20px; font-weight: bold; margin: 0; border-bottom: 1px solid black; padding-bottom: 5px;">
                        Terms and Conditions</p>
                </td>
                <td width="50%" style="text-align: right; padding: 10px; border: 1px solid black;">
                    <p
                        style="font-size: 20px; font-weight: bold; margin: 0; border-bottom: 1px solid black; padding-bottom: 5px;">
                        الشروط:</p>
                </td>
            </tr>
            <tr>
                <td width="50%"
                    style="padding: 10px; border: 1px solid black; line-height: 1.6; vertical-align: top;">
                    <p style="font-size: 20px; margin: 0 0 10px 0;">1) This is my Expression of Interest (EOI) in
                        purchasing the above-noted unit which I acknowledge is not currently available for me to
                        purchase</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">2) As a condition of the Developer accepting this
                        EOI, I have paid the developer the above-noted Deposit.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">3) I acknowledge and understand that:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">(a) This EOI does not give me an
                        interest in or the right to purchase the unit.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">(b) The above-noted purchase
                        price is indicative only, and when the unit becomes available, the price purchase price may be
                        different</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">(c) The deposit will only be
                        refunded in accordance with clause 4, 6(a) and 7; and</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0; padding-left: 20px;">(d) The Purchase Price does not
                        include any applicable VAT or any fees or charges payable to any government entity required for
                        the registration and transfer of the unit.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">4) If the Developer determines, in its sole
                        discretion, that the Unit will not be available for me to purchase, the Developer may
                        unilaterally terminate this EOI at any time upon notice to me and refund my Deposit within
                        thirty (30) days.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">5) The Developer will notify me if the Unit becomes
                        available for me to purchase and confirm the final Purchase Price.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">6) If the final Purchase Price is higher than the
                        indicative Purchase Price, I may:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">a. Choose not to purchase the
                        Unit. If so, this EOI will be automatically terminated, and the Developer will refund my Deposit
                        within thirty (30) days; or</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0; padding-left: 20px;">b. Choose to purchase the Unit
                        at the final Purchase Price, notify the Developer within two (2) business days, and proceed with
                        the purchase in accordance with clause 11.</p>
                </td>
                <td width="50%"
                    style="text-align: right; padding: 10px; border: 1px solid black; line-height: 1.6; direction: rtl; vertical-align: top;">
                    <p style="font-size: 20px; margin: 0 0 10px 0;">1. هذا هو تعبيري عن الاهتمام (EOI) بشراء الوحدة
                        المشار إليها أعلاه، وأُقر بأن هذه الوحدة غير متاحة حاليًا للشراء.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">2. كشرط لقبول المطور لهذا التعبير عن الاهتمام،
                        دفعتُ للمطور العربون المذكور أعلاه.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">3. أُقر وأفهم أن:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">(أ) هذا التعبير عن الاهتمام لا يمنحني أي حق ملكية أو
                        حق في شراء الوحدة.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">(ب) سعر الشراء المذكور أعلاه هو سعر استرشادي فقط،
                        وعند توفر الوحدة قد يكون سعر الشراء مختلفًا.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">(ج) لا يُرد العربون إلا وفقًا للبنود 4 و6(أ) و7.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">(د) سعر الشراء لا يشمل أي ضريبة قيمة مضافة (VAT) أو
                        أي رسوم أو مصاريف مستحقة الدفع لأي جهة حكومية لازمة لتسجيل ونقل ملكية الوحدة.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">4. إذا قرر المطور، وفقًا لتقديره المطلق، أن الوحدة
                        لن تكون متاحة لي للشراء، يحق له إنهاء هذا التعبير عن الاهتمام في أي وقت بموجب إشعار يُوجه إليَّ،
                        على أن يُرد العربون خلال ثلاثين (30) يومًا.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">5. سيقوم المطور بإخطاري إذا أصبحت الوحدة متاحة لي
                        للشراء، وسيؤكد سعر الشراء النهائي</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">6. إذا كان سعر الشراء النهائي أعلى من السعر
                        الاسترشادي، يمكنني:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">أ. اختيار عدم شراء الوحدة. وفي هذه الحالة يُلغى
                        التعبير عن الاهتمام تلقائيًا، ويقوم المطور برد العربون خلال ثلاثين (30) يومًا؛ أو</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">ب. اختيار شراء الوحدة بالسعر النهائي، وإخطار المطور
                        خلال يومي عمل (2)، والمضي قدمًا في الشراء وفقًا للبند 11</p>
                </td>
            </tr>
        </table>
</div>


        <!-- Terms and Conditions -->
        

        <!-- Signature Table for Page 1 -->
        <table
            style="width: 100%; margin-top: 70px; border-top: 2px solid black; padding-top: 20px; border-collapse: collapse;"
            cellpadding="0" cellspacing="0">
            <tr>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Seller</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Purchaser</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Joint Purchaser</p>
                </td>
            </tr>
        </table>
    </div>

    <div class="page-break"></div>
     <style>
    @page {
        margin-top: 40px;
        margin-left: 24px;
        margin-right: 24px;
        margin-bottom: 10px;
    }
</style>


    <div
        style="border: 3px solid #000; padding: 30px; margin: 20px 24px 10px 24px; background: #fff; min-height: 100vh;">
        <!-- Continued Terms and Conditions -->
        <table style="border: 1px solid black; border-collapse: collapse; width: 100%; margin-bottom: 20px;">
            <tr>
                <td width="50%"
                    style="padding: 10px; border: 1px solid black; line-height: 1.6; vertical-align: top;">
                    <p style="font-size: 20px; margin: 0 0 10px 0;">7) If I fail to provide the Developer with notice
                        to proceed in accordance with clause 6(b), this EOI will be automatically terminated, and the
                        Developer will refund my Deposit within thirty (30) days.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">8) If the Developer does not notify me that the
                        Unit has become available for me to purchase within six (6) months of the date of this EOI, I
                        may choose not to purchase the Unit. If so, and upon my written notification to the Developer,
                        this EOI will be automatically terminated, and the Developer will refund my Deposit within
                        thirty (30) days.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">9) Upon the refund of my Deposit, I confirm I will
                        have no claims of any kind against the Developer or its affiliates arising from the termination
                        of this EOI.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">10) If the final Purchase Price is equal to or
                        lower than the Indicative Purchase Price, I agree and acknowledge that I must proceed with the
                        purchase of the Unit in accordance with clause 11.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">11) To proceed with the purchase of the Unit:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">a. The Developer will provide me
                        with a Reservation Agreement for the Unit which I must sign within two (2) business days;</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0; padding-left: 20px;">b. I must make any additional
                        payments due to the Developer at the time of signing the Reservation Agreement; and</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0; padding-left: 20px;">c. The Developer will apply the
                        full amount of the Deposit towards Purchase Price of the Unit.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">12) I confirm that I will not have any legal or
                        beneficial interest in the Unit until the Reservation Agreement for the Unit is signed by me and
                        by the Developer.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">13) The Final Floor Plans for the project and the
                        unit are subject to approval by competent authorities including the Master Developer, and the
                        design, size, number and layout of the unit and the floors in the project and unit are may be
                        subject to change</p>
                </td>
                <td width="50%"
                    style="text-align: right; padding: 10px; border: 1px solid black; line-height: 1.6; direction: rtl; vertical-align: top;">
                    <p style="font-size: 20px; margin: 0 0 10px 0;">7. إذا لم أقم بإخطار المطور بالمتابعة وفقًا للبند
                        6(ب)، يُلغى التعبير عن الاهتمام تلقائيًا، ويقوم المطور برد العربون خلال ثلاثين (30) يومًا.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">8. إذا لم يقم المطور بإخطاري بأن الوحدة قد أصبحت
                        متاحة للشراء خلال ستة (6) أشهر من تاريخ هذا التعبير عن الاهتمام, يمكنني اختيار عدم شراء الوحدة.
                        وفي هذه الحالة، وبمجرد إخطاري الخطي للمطور، يُلغى التعبير عن الاهتمام تلقائيًا, ويقوم المطور برد
                        العربون خلال ثلاثين (30) يومًا</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">9. عند استرداد العربون، أُقر بأني لن يكون لي أي
                        مطالبات من أي نوع ضد المطور أو الشركات التابعة له نتيجة إنهاء هذا التعبير عن الاهتمام.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">10. إذا كان سعر الشراء النهائي مساويًا أو أقل من
                        السعر الاسترشادي، أوافق وأُقر بوجوب المضي قدمًا في شراء الوحدة وفقًا للبند 11.</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">11. للمضي قدمًا في شراء الوحدة:</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">أ. سيقوم المطور بتزويدي باتفاقية الحجز الخاصة
                        بالوحدة، والتي يجب أن أوقعها خلال يومي عمل (2).</p>
                    <p style="font-size: 20px; margin: 0 0 5px 0;">ب. يجب أن أقوم بسداد أي دفعات إضافية مستحقة للمطور
                        عند توقيع اتفاقية الحجز.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">ج. سيُطبق المطور كامل مبلغ العربون المدفوع على سعر
                        شراء الوحدة.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">12. أُقر بأني لن تكون لي أي حقوق قانونية أو حقوق
                        منفعة في الوحدة إلى أن يتم توقيع اتفاقية الحجز الخاصة بالوحدة من قِبلي ومن قِبل المطور.</p>
                    <p style="font-size: 20px; margin: 0 0 10px 0;">13. المخططات النهائية للطوابق الخاصة بالمشروع
                        والوحدة خاضعة لموافقة الجهات المختصة بما في ذلك المطور الرئيسي، وقد تكون التصميمات والمساحات
                        وعدد الغرف وتخطيط الوحدة والطوابق في المشروع والوحدة عرضة للتغيير.</p>
                </td>
            </tr>
        </table>

        <!-- Signature Table for Page 2 -->
        <table
            style="width: 100%; margin-top: 70px; border-top: 2px solid black; padding-top: 20px; border-collapse: collapse;"
            cellpadding="0" cellspacing="0">
            <tr>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Seller</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Purchaser</p>
                </td>
                <td style="width: 33.33%; text-align: center; vertical-align: bottom; padding: 30px 10px;">
                    <div style="border-bottom: 2px solid black; height: 60px; margin-bottom: 10px;"></div>
                    <p style="font-size: 20px; font-weight: bold; margin: 0; text-transform: none;">Joint Purchaser</p>
                </td>
            </tr>
        </table>
        <div style="height: 50px;"></div> 
    </div>

    <div style="page-break-before: always; text-align: center; width: 100%; height: 100%;">
        <img src="<?php echo e(asset('images/office-only-1.png')); ?>" style="width: 100%; height: 1678.1px; object-fit: cover;"
            alt="Office Img">
    </div>
</body>

</html><?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/eoi.blade.php ENDPATH**/ ?>