<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Empire Developments - Bank Accounts Balances</title>
</head>

<body style="font-family: Arial, sans-serif; margin: 20px; background-color: #f5f5f5;">
    <div style="background-color: white; padding: 20px; max-width: 900px; margin: 0 auto; border: 2px solid #000;">

        <!-- Header -->
        <div style="background-color: #8B6914; color: white; text-align: center; padding: 8px; margin-bottom: 2px; font-weight: bold; font-size: 16px;">
            EMPIRE DEVELOPMENTS
        </div>
        <div style="background-color: white; color: black; text-align: center; padding: 4px; margin-bottom: 15px; font-weight: bold; text-decoration: underline; font-size: 14px;">
            BANK ACCOUNTS BALANCES
        </div>

        <!-- Table -->
        <table style="width: 100%; border-collapse: collapse; margin-bottom: 10px;">
            <tr>
                <td style="background-color: #CD853F; color: white; padding: 6px; font-weight: bold; font-size: 13px; width: 60%;">
                    Account Title
                </td>
                <td style="background-color: #CD853F; color: white; padding: 6px; text-align: center; font-weight: bold; font-size: 13px; width: 20%;">
                    Total Debit
                </td>
                <td style="background-color: #CD853F; color: white; padding: 6px; text-align: center; font-weight: bold; font-size: 13px; width: 20%;">
                    Total Credit
                </td>
            </tr>

            <?php
            $grandDebit = 0;
            $grandCredit = 0;
            ?>

            <?php $__currentLoopData = $model; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $grandCredit += $row->total_credit ?? 0;
            $grandDebit += $row->total_debit ?? 0;
            ?>

            <tr>
                <td style="border: 1px solid #000; padding: 4px; font-size: 11px;">
                    <?php echo e($row->accounttitle ?? ''); ?>

                </td>
                <td style="border: 1px solid #000; padding: 4px; text-align: right; font-size: 11px;">
                    <?php echo e($row->total_debit ?? ''); ?>

                </td>
                <td style="border: 1px solid #000; padding: 4px; text-align: right; font-size: 11px;">
                    <?php echo e($row->total_credit ?? ''); ?>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr>
                <td style="background-color: #CD853F; color: white; padding: 6px; font-weight: bold; text-align: center; font-size: 13px;">
                    TOTAL
                </td>
                <td style="background-color: #CD853F; color: white; padding: 6px; text-align: center; font-weight: bold; font-size: 13px;">
                    AED <?php echo e(number_format($grandDebit, 2)); ?>

                </td>
                <td style="background-color: #CD853F; color: white; padding: 6px; text-align: center; font-weight: bold; font-size: 13px;">
                    AED <?php echo e(number_format($grandCredit, 2)); ?>

                </td>
            </tr>
        </table>
    </div>
</body>

</html><?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/bank_reconciliation.blade.php ENDPATH**/ ?>