<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Whatsapp & Email Logs</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    
    <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">

    <style>
        body {
            background: #f8f9fa;
            font-family: "Poppins", sans-serif;
            color: #333;
        }

        .card {
            border-radius: 12px;
            border: none;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
        }

        .card-header {
            background: #fff;
            border-bottom: 2px solid #eee;
            color: #333;
            font-weight: 600;
        }

        table thead {
            background: #f1f1f1;
            color: #333;
        }

        table tbody tr:hover {
            background: #fafafa;
        }

        .badge {
            font-size: 0.8rem;
        }

        .dataTables_wrapper .dataTables_filter input {
            border-radius: 20px;
            padding: 6px 12px;
            background: #fff;
            border: 1px solid #ccc;
            color: #333;
        }
    </style>
</head>

<body>
    <div class="container-fluid py-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0"><i class="fa fa-whatsapp text-success"></i> Whatsapp & Email Logs</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="whatsappTable" class="table table-striped table-hover align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Unit</th>
                                <th>To</th>
                                <th>Body</th>
                                <th>Common Field</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Channel</th>
                                <th>Template</th>
                                <th>Created By</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index+1); ?></td>
                                <td><?php echo e($row->report->unit_no ?? '-'); ?></td>
                                <td><?php echo e($row->to); ?></td>
                                <td>
                                    <a href="javascript:void(0)" 
                                       class="open-body-modal text-decoration-none"
                                       data-body="<?php echo e(base64_encode($row->body)); ?>">
                                        <span title="<?php echo e(strip_tags($row->body)); ?>">
                                            <?php echo e(\Illuminate\Support\Str::limit(strip_tags($row->body), 40)); ?>

                                        </span>
                                    </a>
                                </td>

                                <td>
                                    <?php if(!empty($row->custom_field['name'])): ?>
                                    Name: <?php echo e($row->custom_field['name']); ?> <br>
                                    <?php endif; ?>

                                    <?php if(!empty($row->custom_field['payment_date'])): ?>
                                    Payment Date: <?php echo e(\Carbon\Carbon::parse($row->custom_field['payment_date'])->format('d M Y')); ?>

                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if($row->type == 'email'): ?>
                                    <span class="badge bg-primary">Email</span>
                                    <?php else: ?>
                                    <span class="badge bg-success">Message</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($row->status == 'pending'): ?>
                                    <span class="badge bg-warning text-dark">Pending</span>
                                    <?php elseif($row->status == 'sent'): ?>
                                    <span class="badge bg-success">Sent</span>
                                    <?php else: ?>
                                    <span class="badge bg-danger">Failed</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($row->chanel == 1): ?>
                                    <span class="badge bg-success"><?php echo e($row->chanel); ?></span>
                                    <?php elseif($row->chanel == 2): ?>
                                    <span class="badge bg-primary"><?php echo e($row->chanel); ?></span>
                                    <?php else: ?>
                                    <span class="badge bg-secondary">Other</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($row->template_name); ?></td>
                                <td><?php echo e($row->user->name ?? '-'); ?></td>
                                <td><?php echo e($row->created_at->format('d-M-Y h:i A')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="bodyModal" tabindex="-1" aria-labelledby="bodyModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="bodyModalLabel">Message Body</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body" id="bodyModalContent" style="overflow:auto; max-height:80vh;">
            <!-- Dynamic content will load here -->
          </div>
        </div>
      </div>
    </div>

    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#whatsappTable').DataTable({
                "pageLength": 10,
                "order": [[0, "desc"]],
                "language": {
                    search: "_INPUT_",
                    searchPlaceholder: "Search logs..."
                }
            });

            // Open modal on body click
            $(document).on('click', '.open-body-modal', function () {
                let bodyEncoded = $(this).data('body');
                let bodyContent = atob(bodyEncoded); // decode base64
                $("#bodyModalContent").html(bodyContent);
                $("#bodyModal").modal('show');
            });
        });
    </script>
</body>
</html>
<?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/blade/whatsapp.blade.php ENDPATH**/ ?>