<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>" style="height: 100vh; overflow:hidden;">
    <head>
        <meta charset="utf-8">
        <link rel="shortcut icon" href="<?php echo e(url('images/favicon.png')); ?>" type="image/x-icon">
        <link rel="icon" href="<?php echo e(url('images/favicon.png')); ?>" type="image/x-icon">
        <link rel="stylesheet" href="vue2-autocomplete-js/dist/style/vue2-autocomplete.css">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title><?php echo e(settings()->get('app_title')); ?></title>
        <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script> -->
        <link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet'>
        <link href="<?php echo e(asset('css/vuetify.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/button.css')); ?>" rel="stylesheet">
        <style type="text/css">
            .main-section{
                margin:0 auto;
                padding: 20px;
                margin-top: 100px;
                background-color: #fff;
                box-shadow: 0px 0px 20px #c1c1c1;
            }
            .fileinput-remove,
            .fileinput-upload{
                display: none;
            }
        </style>
        <link rel="stylesheet" type="text/css" href="<?php echo e(mix('css/app.css')); ?>">
    </head>
    <body style="height: 100vh; overflow:hidden;">
    <?php if (is_impersonating()) : ?>
        <div id="fixedDiv" class="fixed_bar ">
            <div class="bar_shape">
                <p>Impersonating <?php echo e(auth()->user()->name); ?> <a href="<?php echo e(route('impersonate.leave')); ?>" class="btn">Leave</a>  <i id="check_pin" class="fa fa-thumb-tack" onclick="pin()" aria-hidden="true"></i></p>
            </div>
        </div>
    <?php endif; ?>
        <div id="root"></div>
    </body>
    <script type="text/javascript">
        window.apex = {
            app_name: "<?php echo e(settings()->get('app_title')); ?>",
            user: {
                id: <?php echo e(auth()->user()->id); ?>,
                name: "<?php echo e(auth()->user()->name); ?>",
                is_admin: <?php echo e(auth()->user()->is_admin); ?>,
                role_id : <?php echo e(auth()->user()->role_id); ?>,
                reservation_days: <?php echo e(auth()->user()->reservation_days); ?>,
                show_sold: <?php echo e(auth()->user()->show_sold); ?>,
                show_available: <?php echo e(auth()->user()->show_available); ?>,
                user_photo : "<?php echo e(auth()->user()->user_photo); ?>",
                partners : "<?php echo e(auth()->user()->partner[0]->partners); ?>"
            }
        }
        function pin() {
            if ($( "#check_pin" ).hasClass( "pin" ))
            {
                $("#check_pin").removeClass('pin');
                $("#fixedDiv").addClass('fixed_bar');
                $("#fixedDiv").removeClass('fixed_pin');
            } else {
                $("#check_pin").addClass('pin');
                $("#fixedDiv").addClass('fixed_pin');
                $("#fixedDiv").removeClass('fixed_bar');
            }
        }
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script type="text/javascript" src="<?php echo e(mix('js/app.js')); ?>"></script>
    <style>
        .float{
            position:fixed;
            width:60px;
            height:50px;
            bottom:40px;
            right:40px;
            background-color: #4267b2;
            color:#FFF;
            border-radius:50px;
            text-align:center;
            box-shadow: 2px 2px 3px #999;
        }

        .my-float{
            margin-top:20px;
            color:#FFF;

        }
        .fixed_bar{
            position: fixed;
            z-index: 999999;
            width: 30%;
            right: 15%;
            top: 0;
        }
        .fixed_pin{
            position: fixed;
            z-index: 999999;
            width: 30%;
            right: 15%;
            top: 0;
        }
        .bar_shape{
            border-top: 7px solid #000;
            width: 80%;
            margin-left: 5%;
            transition: border .5s;
        }
        .pin{
            transform: rotate(0deg) !important;
        }
        .bar_shape::after{
            position: absolute;
            content: "";
            width: 275%;
            height: 78%;
            background-color: #fff;
            clip-path: polygon(30% 0, 0 0%, 15.5% 1345%);
            top: 0;
            left: 3%;
            opacity: 0;
            transform-origin: 0 0 0;
            transition: all 0.5s ease 0s;
            -ms-transform: scaleY(0);
            -webkit-transform: scaleY(0);
            -moz-transform: scaleY(0);
            -o-transform: scaleY(0);
            transform: scaleY(0);
        }
        .fixed_bar:hover .bar_shape{
            border-top:0;
        }
        .fixed_bar:hover .bar_shape::after{
            opacity: 1;
            -ms-transform: scaleY(1);
            -webkit-transform: scaleY(1);
            -moz-transform: scaleY(1);
            -o-transform: scaleY(1);
            transform: scaleY(1);
        }
        /*.fixed_bar:hover::after{*/
        /*opacity: 1;*/
        /*}*/
        .fixed_bar p{
            z-index: 999999;
            color: #000;
            position: relative;
            text-align: center;
            font-size: 15px;
            font-weight: bold;
            margin-top: 0;
            padding-bottom: 3%;
            /*margin-left: 12%;*/
            opacity: 0;
            transition: opacity .2s;
            cursor: default;
        }
        .fixed_pin p{
            z-index: 999999;
            color: black;
            position: relative;
            text-align: center;
            font-size: 15px;
            font-weight: bold;
            margin-top: 0;
            padding-bottom: 3%;
            /*margin-left: 12%;*/
            opacity: 1;
            cursor: default;
        }
        .fixed_bar:hover p,.fixed_bar:hover p a{
            opacity: 1;
        }
        .fixed_bar p a{
            color: #fff;
            padding: 5px 12px;
            margin-left: 10px;
            padding-top: 4px;
            font-weight: 500;
            border-radius: 5px;
            opacity: 0;
            transition: opacity 1s;
            border: 1px solid #fff;
        }
        .fixed_bar p a:hover {
            background: white;
            color: #4267b2;
            border: 2px solid #4267b2;
        }
        .fixed_pin p a{
            color: #fff;
            padding: 5px 12px;
            margin-left: 10px;
            padding-top: 4px;
            font-weight: 500;
            border-radius: 5px;
            opacity: 1;
            border: 1px solid #fff;
        }
        .fixed_pin p a:hover {
            background: #fff;
            color: #4267b2;
            border: 2px solid #4267b2;
        }
        .fixed_pin .bar_shape::after{
            position: absolute;
            content: "";
            width: 275%;
            height: 78%;
            background-color: #fff;
            clip-path: polygon(30% 0, 0 0%, 15.5% 1345%);
            top: 0;
            left: 3%;
            opacity: 1;
            transform-origin: 0 0 0;
            transition: all 0.5s ease 0s;
            transform: scaleY(1);
            border: 1px solid black;
        }

        .fa-thumb-tack{
            margin-left: 2%;
            transform: rotate(45deg);
            font-size: 18px;
            vertical-align: sub;
            cursor: pointer;
            transition: transform .5s;
        }
        /*RESPONSIVE STYle*/
        @media (min-width: 1280px) and (max-width: 1366px) {
            .bar_shape{
                width: 100% !important;
                margin-left: 5% !important;
            }
            .bar_shape::after{
                width: 341% !important;
            }
        }
        @media (min-width: 1367px) and (max-width: 1440px){
            .bar_shape{
                width: 92% !important;
            }
            .bar_shape::after{
                width: 317% !important;
            }
        }
        @media (min-width: 1441px) and (max-width: 1600px){
            .bar_shape{
                width: 85% !important;
            }
            .bar_shape::after{
                width: 292% !important;
            }
        }
        @media (min-width: 1681px) and (max-width: 1920px){
        }
    </style>
</html>
<?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/app.blade.php ENDPATH**/ ?>