<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chart of Accounts</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />

    <style>
        body {
            background-color: #f9fafb;
        }

        .card {
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
        }

        .table th, .table td {
            vertical-align: middle;
        }

        .form-select-sm, .form-control-sm {
            min-width: 160px;
        }

        .btn-success {
            min-width: 80px;
        }

        .btn-danger {
            min-width: 120px;
        }
    </style>
</head>

<body>
    <div class="container py-5">

        <div class="card">
            <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">📊 Chart of Accounts</h5>
                <button type="button" onclick="deleteSelected()" class="btn btn-danger btn-sm">
                    🗑️ Delete Selected
                </button>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover mb-0">
                        <thead class="table-dark text-center">
                            <tr>
                                <th>#</th>
                                <th>Group Class Type</th>
                                <th>Group Class</th>
                                <th>Group Name</th>
                                <th>Account Title</th>
                                <th>Account Code</th>
                                <th>Action</th>
                                <th>Select</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(route('coa.update', $account->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <tr class="text-center">
                                        <td><?php echo e($key + 1); ?></td>
                                        <td>
                                            <select name="class_type_id" class="form-select form-select-sm class-type-select"
                                                data-account-id="<?php echo e($account->id); ?>">
                                                <?php $__currentLoopData = $class_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($class_type->id); ?>"
                                                        <?php if($class_type->class_type == $account->class_type_name): ?> selected <?php endif; ?>>
                                                        <?php echo e($class_type->class_type); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>

                                        <td>
                                            <select name="class_id" class="form-select form-select-sm class-select"
                                                data-account-id="<?php echo e($account->id); ?>">
                                                <?php $__currentLoopData = $account_classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($class->id); ?>"
                                                        <?php if($class->classname == $account->class_name): ?> selected <?php endif; ?>>
                                                        <?php echo e($class->classname); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>

                                        <td>
                                            <select name="group_id" class="form-select form-select-sm group-select"
                                                data-account-id="<?php echo e($account->id); ?>">
                                                <?php $__currentLoopData = $account_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($group->id); ?>"
                                                        <?php if($group->groupname == $account->group_name): ?> selected <?php endif; ?>>
                                                        <?php echo e($group->groupname); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>

                                        <td><input type="text" class="form-control form-control-sm text-center"
                                                name="account_title" value="<?php echo e($account->accounttitle); ?>"></td>

                                        <td><input type="text" class="form-control form-control-sm text-center"
                                                name="account_code" value="<?php echo e($account->accountcode); ?>"></td>

                                        <td>
                                            <button type="submit" class="btn btn-success btn-sm">💾 Save</button>
                                        </td>

                                        <td>
                                            <input type="checkbox" class="form-check-input delete-checkbox"
                                                name="select[]" value="<?php echo e($account->id); ?>"
                                                style="height: 20px; width: 20px;">
                                        </td>
                                    </tr>
                                </form>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        toastr.options = {
            "positionClass": "toast-bottom-right",
        };

        <?php if(session()->has('success')): ?>
            toastr.success(<?php echo json_encode(session('success'), 15, 512) ?>);
            <?php session()->forget('success'); ?>
        <?php endif; ?>

        <?php if(session()->has('error')): ?>
            toastr.error(<?php echo json_encode(session('error'), 15, 512) ?>);
            <?php session()->forget('error'); ?>
        <?php endif; ?>

        function deleteSelected() {
            let selectedIds = [];
            $('.delete-checkbox:checked').each(function() {
                selectedIds.push($(this).val());
            });

            if (selectedIds.length === 0) {
                toastr.warning("No records selected!");
                return;
            }

            if (!confirm('Are you sure you want to delete selected records?')) {
                return;
            }

            $.ajax({
                url: `<?php echo e(route('coa.deleteSelected')); ?>`,
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    ids: selectedIds
                },
                success: function(response) {
                    toastr.success(response.message || 'Selected records deleted!');
                    setTimeout(() => location.reload(), 1000);
                },
                error: function(xhr) {
                    toastr.error('An error occurred while deleting.');
                }
            });
        }

        // Load classes based on class type
        $('.class-type-select').change(function() {
            let classTypeId = $(this).val();
            let accountId = $(this).data('account-id');

            $.ajax({
                url: '<?php echo e(route('getClassesByClassType')); ?>',
                type: 'GET',
                data: {
                    class_type_id: classTypeId
                },
                success: function(classes) {
                    let classSelect = $('.class-select[data-account-id="' + accountId + '"]');
                    classSelect.empty();
                    $.each(classes, function(_, cls) {
                        classSelect.append('<option value="' + cls.id + '">' + cls.classname + '</option>');
                    });

                    // Trigger class change to load groups
                    classSelect.trigger('change');
                }
            });
        });

        // Load groups based on class
        $('.class-select').change(function() {
            let classId = $(this).val();
            let accountId = $(this).data('account-id');

            $.ajax({
                url: '<?php echo e(route('getGroupsByClass')); ?>',
                type: 'GET',
                data: {
                    class_id: classId
                },
                success: function(groups) {
                    let groupSelect = $('.group-select[data-account-id="' + accountId + '"]');
                    groupSelect.empty();
                    $.each(groups, function(_, group) {
                        groupSelect.append('<option value="' + group.id + '">' + group.groupname + '</option>');
                    });
                }
            });
        });
    </script>
</body>

</html><?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/chart-of-accounts/index.blade.php ENDPATH**/ ?>