
<?php $__env->startSection('content'); ?>
<div class="document">
    <div class="document-heading">
        <div class="row">
            <div class="col col-1">
                <img src="<?php echo e(base_path('storage/app/uploads/' . settings()->get('uploaded_logo'))); ?>" style="width:100px; margin-top: -25px;">
            </div>
            <div class="col col-8" style=" margin-top: 50px;">
                <h1 class="align-left" style="font-family:verdana;color:#6e1913; font-weight:bold;"><?php echo e(settings()->get('company_name')); ?></h1>
            </div>
            <div class="col col-3 align-right">
                Dated: <?php echo e(date('d-m-Y')); ?>

            </div>
        </div>
    </div>

    <div class="document-body">
        
        <table class="document-table">
            <thead>
                <tr style="height:25px">
                    <th colspan="11" style="text-align: left;font-size: 150%;font-weight:bold">Sold Unit</th>
                </tr>
                <tr>
                    <th>#</th>
                    <th>Project</th>
                    <th>Unit Type</th>
                    <th>Total Unit</th>
                    <th>Sold Unit</th>
                    <th>Sold Area</th>
                    <th>Sold Price</th>
                    <th>Rate / SQFT</th>
                    <th>Receipts</th>
                    <th>Receipts %</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <?php
                $i = 1;
                $total_units = 0;
                $total_sold_area = 0;
                $total_sale_price = 0;
                $total_receipts = 0;
            ?>
            <tbody>
                <?php $__currentLoopData = $model['sold']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $total_units += $item->total_units;
                        $total_sold_area += $item->unit_gross_area;
                        $total_sale_price += $item->unit_sale_price;
                        $total_receipts += $item->unit_total_received;
                    ?>
                    <tr>
                        <td><?php echo e($i++); ?></td>
                        <td><?php echo e($item->project); ?></td>
                        <td><?php echo e($item->unit_type); ?></td>
                        <td class="align-right"><?php echo e($item->total_units); ?></td>
                        <td class="align-right"><?php echo e($item->total_units); ?></td>
                        <td class="align-right"><?php echo e(number_format($item->unit_gross_area, 0)); ?></td>
                        <td class="align-right"><?php echo e(number_format($item->unit_sale_price, 0)); ?></td>
                        <td class="align-right">
                            <?php echo e(number_format($item->unit_gross_area > 0 ? $item->unit_sale_price / $item->unit_gross_area : 0)); ?>

                        </td>
                        <td class="align-right"><?php echo e(number_format($item->unit_total_received, 0)); ?></td>
                        <td class="align-right">
                            <?php echo e(number_format($item->unit_sale_price > 0 ? ($item->unit_total_received / $item->unit_sale_price) * 100 : 0)); ?>

                        </td>
                        <td class="align-right">
                            <?php echo e(number_format($item->unit_sale_price - $item->unit_total_received)); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <tr style="font-weight: bold;">
                    <td colspan="3">Total</td>
                    <td class="align-right"><?php echo e(number_format($total_units)); ?></td>
                    <td class="align-right"><?php echo e(number_format($total_units)); ?></td>
                    <td class="align-right"><?php echo e(number_format($total_sold_area)); ?></td>
                    <td class="align-right"><?php echo e(number_format($total_sale_price)); ?></td>
                    <td class="align-right">
                        <?php echo e(number_format($total_sold_area > 0 ? $total_sale_price / $total_sold_area : 0)); ?>

                    </td>
                    <td class="align-right"><?php echo e(number_format($total_receipts)); ?></td>
                    <td class="align-right">
                        <?php echo e(number_format($total_sale_price > 0 ? ($total_receipts / $total_sale_price) * 100 : 0)); ?>%
                    </td>
                    <td class="align-right">
                        <?php echo e(number_format($total_sale_price - $total_receipts)); ?>

                    </td>
                </tr>
            </tbody>
        </table>

        
        <br><br><br>
        <table class="document-table" style="width:85%">
            <thead>
                <tr style="height:25px">
                    <th colspan="8" style="text-align: left;font-size: 150%;font-weight:bold">Available Unit</th>
                </tr>
                <tr>
                    <th style="text-align: left;width:3%">#</th>
                    <th style="text-align: left;width:10%">Project</th>
                    <th style="text-align: center;width:10%">Unit Type</th>
                    <th style="text-align: center">Total Unit</th>
                    <th style="text-align: center">Available Unit</th>
                    <th style="text-align: center">Avail Area</th>
                    <th style="text-align: center">Available Price</th>
                    <th style="text-align: center">Rate / SQFT</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $j = 1;
                    $total_avail_units = 0;
                    $total_avail_area = 0;
                    $total_avail_price = 0;
                ?>
                <?php $__currentLoopData = $model['available']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $total_avail_units += $item->available_units;
                        $total_avail_area += $item->gross_area;
                        $total_avail_price += $item->total_price;
                    ?>
                    <tr>
                        <td><?php echo e($j++); ?></td>
                        <td><?php echo e($item->projectname); ?></td>
                        <td><?php echo e($item->unittypedetail); ?></td>
                        <td class="align-right"><?php echo e($item->total_units); ?></td>
                        <td class="align-right"><?php echo e($item->available_units); ?></td>
                        <td class="align-right"><?php echo e(number_format($item->gross_area, 0)); ?></td>
                        <td class="align-right"><?php echo e(number_format($item->total_price, 0)); ?></td>
                        <td class="align-right">
                            <?php echo e(number_format($item->gross_area > 0 ? $item->total_price / $item->gross_area : 0)); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <tr style="font-weight: bold;">
                    <td colspan="4">Total</td>
                    <td class="align-right"><?php echo e(number_format($total_avail_units)); ?></td>
                    <td class="align-right"><?php echo e(number_format($total_avail_area)); ?></td>
                    <td class="align-right"><?php echo e(number_format($total_avail_price)); ?></td>
                    <td class="align-right">
                        <?php echo e(number_format($total_avail_area > 0 ? $total_avail_price / $total_avail_area : 0)); ?>

                    </td>
                </tr>
            </tbody>
        </table>

        
        <div class="row">
            <div class="col col-8" style="margin-top: -8px"></div>
            <div class="col col-4 align-right" style="margin-top: -8px">
                <br />
                <p style="font-style: italic;text-align: left">
                    Printed On: <?php echo e(date('d-m-Y h:i:s A')); ?> by <?php echo e(Auth::user()->name); ?>

                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('docs.master', ['title'=> 'Project Report '], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Softwares\laragon\www\empiredevelopments-finance\resources\views/docs/sale_project_report.blade.php ENDPATH**/ ?>